#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//The Dancefloor   by  Peetu  
//https://www.shadertoy.com/view/wdXGRS
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float EPSILON = 0.0001;
const float end = 100.0;
const float start = 0.01;
const float PI = 3.14159265359;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float r = 0.05;
float sdRoundBox(vec3 p) {
    return length(max(abs(p) - vec3(.25, 10.5, .25), 0.0)) - r;
}

float c = .68;
vec4 sceneSDF(vec3 p) {
    vec3 q = mod(p,c)-0.5*c;
    vec3 z1 = floor(p / c) + vec3(floor(iTime)) * 25.12;
    vec3 z2 = floor(p / c) + vec3(floor(iTime) + 1.) * 25.12;
    q.y = p.y;
    float d = sdRoundBox(q);
    
    vec3 col1 = vec3(
        rand(z1.xz * 2.14), rand(z1.xz * 3.52), rand(z1.zx * 5.21)
    );
    vec3 col2 = vec3(
        rand(z2.xz * 2.14), rand(z2.xz * 3.52), rand(z2.zx * 5.21)
    );
    
    return vec4(mix(col1, col2, mod(iTime, 1.)), d);
}

mat3 rotationMatrixY(float rad) {
    return mat3(
        vec3(cos(rad), 0.0, sin(rad)),
        vec3(0.0, 1.0, 0.0),
        vec3(-sin(rad), 0.0, cos(rad))
    );
}

mat3 rotationMatrixX(float rad) {
    return mat3(
        vec3(1.0, 0.0, 0.0),
        vec3(0.0, cos(rad), -sin(rad)),
        vec3(0.0, sin(rad), cos(rad))
    ); 
}

mat3 rotationMatrixZ(float rad) {
    return mat3(
        vec3(cos(rad), -sin(rad), 0.0),
        vec3(sin(rad), cos(rad), 0.0),
        vec3(0.0, 0.0, 1.0)
    );
}

vec4 rayMarch(vec3 eye, vec3 rayDir) {
    float depth = start;
    for(int i = 0; i < 255; i++) {
   		vec4 data = sceneSDF(eye + rayDir * depth);
        float dist = data.w;
        
        if(dist < EPSILON){
 	      	return vec4(data.xyz, depth);   
        }else if(depth >= end) {
        	return vec4(vec3(0.0), end);   
        }
        
        depth += dist;
    }
    return vec4(vec3(0.0), end);
}

vec3 estimateNormal(vec3 p) {
    float E = 0.1;
    return normalize(vec3(
        sceneSDF(vec3(p.x + E, p.y, p.z)).w - sceneSDF(vec3(p.x - E, p.y, p.z)).w,
        sceneSDF(vec3(p.x, p.y + E, p.z)).w - sceneSDF(vec3(p.x, p.y - E, p.z)).w,
        sceneSDF(vec3(p.x, p.y, p.z + E)).w - sceneSDF(vec3(p.x, p.y, p.z - E)).w
    ));
}

vec3 rayDirection(float fov, vec2 size, vec2 fragCoord) {
    vec2 xy = fragCoord - size / 2.0;
    float z = size.y / tan(radians(fov) / 2.0);
    return normalize(vec3(xy, -z));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{          



    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.y;
    
    float t = iTime * 0.1;
    float rSine = 0.6 * sin(3. * t) + 1.6 * sin(0.7 * t) - 2.1 * sin(0.2 * t);
    
    
	mat3 rot = rotationMatrixY(rSine) * rotationMatrixX(0.5);
    
    vec3 eye = vec3(0.0, 14.0, 5. - iTime);
    vec3 rayDir = rot * rayDirection(45.0, iResolution.xy, fragCoord);
    
    vec4 data = rayMarch(eye, rayDir);
    float depth = data.w;
    
    vec3 col;
   
   	if(depth >= end - EPSILON) {
    	col = vec3(0.);
    }else{
        vec3 normal = estimateNormal(eye + depth * rayDir);
        vec3 light = vec3(-1.0, -.4, .9) * rotationMatrixY(0.5);
        float diffuse = clamp(dot(normal, -light), 0.0, 1.0) * .8;
        
        vec3 viewDir = normalize(-rayDir);
		vec3 reflectDir = reflect(light, normal);  
        float specular = pow(max(dot(viewDir, reflectDir) * .75, 0.0), 8.) * .5;
        float i = 0.1 + diffuse + specular;
        col = data.xyz * i;
    }
    
    fragColor = vec4(col,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

